'use strict';

var Node = require(__dirname);

module.exports = Node.define({
  type: 'COLUMN',
  constructor: function(config) {
    Node.call(this);
    this.name = config.name;
    this.property = config.property || config.name;
    this.alias = config.alias;
    this.star = config.star;
    this.asArray = config.asArray;
    this.aggregator = config.aggregator;
    this.table = config.table;
    this.value = config.getValue();
    this.dataType = config.dataType;
    this.distinct = config.distinct;
    this.primaryKey = config.primaryKey;
    this.references = config.references;
    this.autoGenerated = !!config.autoGenerated;
  },
  as: function(alias) {
    this.alias = alias;
    return this;
  }
});
